// ESP32 Dev Module

#define ARDUINO_RUNNING_CORE 1
#define RELAY1 2
#define RELAY2 13
#define BUTTON1 39
#define BUTTON2 34
#define DAC1 26


#include <WiFi.h>


const char* ssid = "TurkTelekom_TP2A42_2.4GHz";
const char* password = "zF4ngpkyKuDx9";

const int MAXTAG = 5;
const int COMMAND_LEN = 1;  

//1:10  adr 1 value 1 

// LZ Define
const String LineEnd = String("\r\n");
String StringBuf;


typedef struct TTags {
 // String TagName;
  int TagValue;
};


TTags Tags[MAXTAG];
WiFiServer wifiServer(80);


void setup() {


  // setup serial
  Serial.begin(9600);
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    Serial.println("Wait Connecting to WiFi..");
  }


  Serial.println("Connected to the WiFi network");
  Serial.println(WiFi.localIP());
  wifiServer.begin();
  delay(200);

  // define tags
  Tags[0] = (TTags){ 10 };  //  Default Value = 10  Analog Output1
  Tags[1] = (TTags){ 0 };   //  Default Value = 0   Button1
  Tags[2] = (TTags){ 0 };   //  Default Value = 0   Button2
  Tags[3] = (TTags){ 0 };   //  Default Value = 0   RELAY1
  Tags[4] = (TTags){ 0 };   //  Default Value = 0   RELAY2

  pinMode(BUTTON1, INPUT);  // set pin to input Button 1
  pinMode(BUTTON2, INPUT);  // set pin to input Button 2

  pinMode(RELAY1, OUTPUT);  // set pin to Led 1
  pinMode(RELAY2, OUTPUT);  // set pin to Led 2

  digitalWrite(RELAY1, HIGH);
  delay(500);
  digitalWrite(RELAY1, LOW);


  // Now set up two tasks to run independently.
  xTaskCreatePinnedToCore(
    Task1, "Task1", 1024, NULL, 2,
    NULL, ARDUINO_RUNNING_CORE);

  xTaskCreatePinnedToCore(
    Task2, "Task2", 2048  // Stack size
    ,
    NULL, 1, NULL, ARDUINO_RUNNING_CORE);
}

void loop() {
}

/*---------------------- Tasks ---------------------*/

void Task1(void* pvParameters)  // This is a task.
{
  (void)pvParameters;
  for (;;) {


    //  Gets
    Tags[1].TagValue = digitalRead(BUTTON1);  // Get Button 1
    Tags[2].TagValue = digitalRead(BUTTON2);  // Get Button 2

    // Sets
    if (Tags[3].TagValue == 1) digitalWrite(RELAY1, HIGH);
    else digitalWrite(RELAY1, LOW);
    if (Tags[4].TagValue == 1) digitalWrite(RELAY2, HIGH);
    else digitalWrite(RELAY2, LOW);

    // analog Output
    dacWrite(DAC1, Tags[0].TagValue);

    vTaskDelay(1);
  }
}

void Task2(void* pvParameters)  // This is a task.
{

  (void)pvParameters;

  for (;;) {
    String StringBuf, ValueString, IndexString;
    char inChar;
    int i, Index;

    WiFiClient client = wifiServer.available();

    if (client) {

      while (client.connected()) {

        while (client.available() > 0) {
          inChar = client.read();
          StringBuf += inChar;

          if (StringBuf.endsWith(LineEnd)) {
            
            IndexString = StringBuf.substring(0, COMMAND_LEN);
            if ( IndexString.length() > 0  ) {
              Index = StringBuf.substring(0, COMMAND_LEN).toInt();
              if ( Index >= 0 &&  Index < MAXTAG ){
                ValueString = StringBuf.substring(COMMAND_LEN  , StringBuf.length() - LineEnd.length()  );
                if (ValueString.length() > 0  )  Tags[Index].TagValue = ValueString.toInt();
                client.print(IndexString + Tags[Index].TagValue + LineEnd);
              }
            } 
          }
        }

        StringBuf = "";
      }

      client.stop();
    }

  };  // end for


}  // end task
